#ifdef _DEBUG
#include <stdio.h>
#endif

#include <windows.h>
#include "Gfx #1.3.h"
#include "rdp.h"
#include "vi.h"

int overlay = 1;
/*
 * dynamically configured by means of DllConfig
 * enables or disables emulation of appropriate VI filters over RDRAM pixels
 */

int skip = 0;
/*
 * AI/VI thread timing hack for when audio thread is overcome by VI requests
 * skips drawing every 30 vertical interrupts to balance out the botteneck
 */

int step = 0;
/*
 * currently just pops a message box every time ScreenUpdate is called
 * useful for taking animated screenshots of consecutive video frames
 */

EXPORT void CALL DllAbout(HWND hParent)
{
    MessageBox(
        hParent,
        "angrylion's RDP, unpublished beta. MESS source code used.",
        "DllAbout",
        MB_ICONINFORMATION);
    return;
}

EXPORT void CALL DllConfig(HWND hParent)
{
    int response;
#ifdef _DEBUG
    char text_buf[192];

    sprintf(
        text_buf,

        "CYCLE_TYPE_1   :  %d\n"\
        "CYCLE_TYPE_2   :  %d\n"\
        "CYCLE_TYPE_COPY:  %d\n"\
        "CYCLE_TYPE_FILL:  %d",

        render_cycle_mode_counts[CYCLE_TYPE_1],
        render_cycle_mode_counts[CYCLE_TYPE_2],
        render_cycle_mode_counts[CYCLE_TYPE_COPY],
        render_cycle_mode_counts[CYCLE_TYPE_FILL]);
    MessageBox(hParent, text_buf, "Render Spans Cycle Mode Counts", MB_OK);
#endif
    response = MessageBox(
        hParent, "Emulate VI DAC filters?", "Frame Buffer Overlay", MB_YESNO);
    if (response == IDYES || response == IDNO)
        overlay = (response == IDYES);

    response = MessageBox(
        hParent,
        "VI only updates screen every twenty frame buffers?",
        "RCP AI/VI Thread Priority Hack (frame skip)", MB_YESNOCANCEL);
    if (response == IDYES || response == IDNO)
        skip = 20*(response == IDYES);

    response = MessageBox(
        hParent, "Pause after each screen update?", "Frame Stepping", MB_YESNO);
    if (response == IDYES || response == IDNO)
        step = (response == IDYES);

#ifdef TRACE_DP_COMMANDS
    count_DP_commands();
#endif
    return;
}

EXPORT void CALL DllTest(HWND hParent)
{
    return;
}
